/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.analysis.dpCommon.ThresholdAnalysis;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.JCChart;

public class HistogramPanel
extends Panel {
    private CardLayout clman;
    private Vector graphNames;
    private ResourceBundle res = ResourceBundle.getBundle("ibm.nways.nhm.eui.AnalysisPanelResources");

    public HistogramPanel() {
        this.initialize();
    }

    public void initialize() {
        this.clman = new CardLayout();
        this.setLayout(this.clman);
        this.graphNames = new Vector();
    }

    public void addChart(ThresholdAnalysis thresholdAnalysis) {
        JCChart jCChart = new JCChart(9);
        jCChart.setBackground(Color.white);
        jCChart.setForeground(Color.red);
        jCChart.getChartArea().setBackground(Color.white);
        jCChart.getChartArea().setForeground(Color.red);
        jCChart.getHeader().setText(thresholdAnalysis.getId());
        jCChart.getHeader().setIsShowing(true);
        ChartDataView chartDataView = jCChart.getDataView(0);
        chartDataView.setDataSource(thresholdAnalysis);
        chartDataView.getXAxis().setForeground(Color.black);
        chartDataView.getYAxis().setForeground(Color.black);
        chartDataView.getXAxis().getTitle().setForeground(Color.black);
        chartDataView.getYAxis().getTitle().setForeground(Color.black);
        chartDataView.getXAxis().getTitle().setText(this.res.getString("s_Tod"));
        chartDataView.getYAxis().getTitle().setText(this.res.getString("s_NumEvents"));
        chartDataView.getYAxis().getTitle().setRotation(3);
        chartDataView.getYAxis().getTitle().setPlacement(2);
        ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
        chartDataViewSeriesArray[0].getStyle().setFillColor(Color.red);
        this.add(thresholdAnalysis.getId(), jCChart);
        this.graphNames.addElement(thresholdAnalysis.getId());
        this.clman.next(this);
    }

    public void showChart(String string) {
        this.clman.show(this, string);
    }

    public boolean alreadyExists(String string) {
        boolean bl = false;
        Enumeration enumeration = this.graphNames.elements();
        while (!bl && enumeration.hasMoreElements()) {
            if (!string.equals(enumeration.nextElement())) continue;
            bl = true;
        }
        return bl;
    }
}

